﻿using System.IO;
using System.Text;
using System.Xml.Serialization;

namespace VA.PPMS.IWS.Common
{
    public static class Utilities
    {
        public static string Base64Decode(byte[] base64EncodedBytes)
        {
            return Encoding.UTF8.GetString(base64EncodedBytes);
        }

        public static T Deserialize<T>(string payload)
        {
            var serializer = new XmlSerializer(typeof(T));
            using (var stringReader = new StringReader(payload))
            {
                var result = (T)serializer.Deserialize(stringReader);
                return result;
            }
        }

        public static string SerializeInstance<T>(T classInstance, string prefix, string nameSpace)
        {
            using (var stream = new MemoryStream())
            {
                var serializer = new XmlSerializer(typeof(T));
                var ns = new XmlSerializerNamespaces();

                ns.Add(prefix, nameSpace);

                serializer.Serialize(stream, classInstance, ns);
                return Encoding.UTF8.GetString(stream.ToArray());
            }
        }
    }
}